/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeSnapshotsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSnapshotsRequestMarshaller implements
        Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {

    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {

        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest,
                "EC2Client");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeSnapshotsRequestFiltersList = describeSnapshotsRequest.filters();
        if (describeSnapshotsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeSnapshotsRequestFiltersListValue : describeSnapshotsRequestFiltersList) {

                if (describeSnapshotsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeSnapshotsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeSnapshotsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeSnapshotsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeSnapshotsRequest.maxResults()));
        }

        if (describeSnapshotsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeSnapshotsRequest.nextToken()));
        }

        java.util.List<String> describeSnapshotsRequestOwnerIdsList = describeSnapshotsRequest.ownerIds();
        if (describeSnapshotsRequestOwnerIdsList != null) {
            int ownerIdsListIndex = 1;

            for (String describeSnapshotsRequestOwnerIdsListValue : describeSnapshotsRequestOwnerIdsList) {
                if (describeSnapshotsRequestOwnerIdsListValue != null) {
                    request.addParameter("Owner." + ownerIdsListIndex,
                            StringUtils.fromString(describeSnapshotsRequestOwnerIdsListValue));
                }
                ownerIdsListIndex++;
            }
        }

        java.util.List<String> describeSnapshotsRequestRestorableByUserIdsList = describeSnapshotsRequest.restorableByUserIds();
        if (describeSnapshotsRequestRestorableByUserIdsList != null) {
            int restorableByUserIdsListIndex = 1;

            for (String describeSnapshotsRequestRestorableByUserIdsListValue : describeSnapshotsRequestRestorableByUserIdsList) {
                if (describeSnapshotsRequestRestorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + restorableByUserIdsListIndex,
                            StringUtils.fromString(describeSnapshotsRequestRestorableByUserIdsListValue));
                }
                restorableByUserIdsListIndex++;
            }
        }

        java.util.List<String> describeSnapshotsRequestSnapshotIdsList = describeSnapshotsRequest.snapshotIds();
        if (describeSnapshotsRequestSnapshotIdsList != null) {
            int snapshotIdsListIndex = 1;

            for (String describeSnapshotsRequestSnapshotIdsListValue : describeSnapshotsRequestSnapshotIdsList) {
                if (describeSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex,
                            StringUtils.fromString(describeSnapshotsRequestSnapshotIdsListValue));
                }
                snapshotIdsListIndex++;
            }
        }

        return request;
    }

}
