/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeSpotPriceHistoryResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSpotPriceHistoryResponseUnmarshaller implements
        Unmarshaller<DescribeSpotPriceHistoryResponse, StaxUnmarshallerContext> {

    public DescribeSpotPriceHistoryResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeSpotPriceHistoryResponse.Builder describeSpotPriceHistoryResponse = DescribeSpotPriceHistoryResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<SpotPrice> spotPriceHistory = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeSpotPriceHistoryResponse.spotPriceHistory(spotPriceHistory);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("nextToken", targetDepth)) {
                    describeSpotPriceHistoryResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotPriceHistorySet", targetDepth)) {
                    spotPriceHistory = new ArrayList<SpotPrice>();
                    continue;
                }

                if (context.testExpression("spotPriceHistorySet/item", targetDepth)) {
                    spotPriceHistory.add(SpotPriceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeSpotPriceHistoryResponse.spotPriceHistory(spotPriceHistory);
                    break;
                }
            }
        }
        return describeSpotPriceHistoryResponse.build();
    }

    private static final DescribeSpotPriceHistoryResponseUnmarshaller INSTANCE = new DescribeSpotPriceHistoryResponseUnmarshaller();

    public static DescribeSpotPriceHistoryResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
