/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeStaleSecurityGroupsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeStaleSecurityGroupsResponseUnmarshaller implements
        Unmarshaller<DescribeStaleSecurityGroupsResponse, StaxUnmarshallerContext> {

    public DescribeStaleSecurityGroupsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeStaleSecurityGroupsResponse.Builder describeStaleSecurityGroupsResponse = DescribeStaleSecurityGroupsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<StaleSecurityGroup> staleSecurityGroupSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeStaleSecurityGroupsResponse.staleSecurityGroupSet(staleSecurityGroupSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("nextToken", targetDepth)) {
                    describeStaleSecurityGroupsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("staleSecurityGroupSet", targetDepth)) {
                    staleSecurityGroupSet = new ArrayList<StaleSecurityGroup>();
                    continue;
                }

                if (context.testExpression("staleSecurityGroupSet/item", targetDepth)) {
                    staleSecurityGroupSet.add(StaleSecurityGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeStaleSecurityGroupsResponse.staleSecurityGroupSet(staleSecurityGroupSet);
                    break;
                }
            }
        }
        return describeStaleSecurityGroupsResponse.build();
    }

    private static final DescribeStaleSecurityGroupsResponseUnmarshaller INSTANCE = new DescribeStaleSecurityGroupsResponseUnmarshaller();

    public static DescribeStaleSecurityGroupsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
