/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ExportToS3TaskSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ExportToS3TaskSpecificationUnmarshaller implements
        Unmarshaller<ExportToS3TaskSpecification, StaxUnmarshallerContext> {

    public ExportToS3TaskSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        ExportToS3TaskSpecification.Builder exportToS3TaskSpecification = ExportToS3TaskSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("containerFormat", targetDepth)) {
                    exportToS3TaskSpecification.containerFormat(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("diskImageFormat", targetDepth)) {
                    exportToS3TaskSpecification.diskImageFormat(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("s3Bucket", targetDepth)) {
                    exportToS3TaskSpecification.s3Bucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("s3Prefix", targetDepth)) {
                    exportToS3TaskSpecification.s3Prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return exportToS3TaskSpecification.build();
    }

    private static final ExportToS3TaskSpecificationUnmarshaller INSTANCE = new ExportToS3TaskSpecificationUnmarshaller();

    public static ExportToS3TaskSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
