/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * Image StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImageUnmarshaller implements Unmarshaller<Image, StaxUnmarshallerContext> {

    public Image unmarshall(StaxUnmarshallerContext context) throws Exception {
        Image.Builder image = Image.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ProductCode> productCodes = null;
        java.util.List<BlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                image.productCodes(productCodes);
                image.blockDeviceMappings(blockDeviceMappings);
                image.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("architecture", targetDepth)) {
                    image.architecture(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("creationDate", targetDepth)) {
                    image.creationDate(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageId", targetDepth)) {
                    image.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageLocation", targetDepth)) {
                    image.imageLocation(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageType", targetDepth)) {
                    image.imageType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernelId", targetDepth)) {
                    image.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageOwnerId", targetDepth)) {
                    image.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("platform", targetDepth)) {
                    image.platform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdiskId", targetDepth)) {
                    image.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageState", targetDepth)) {
                    image.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    image.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("enaSupport", targetDepth)) {
                    image.enaSupport(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hypervisor", targetDepth)) {
                    image.hypervisor(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageOwnerAlias", targetDepth)) {
                    image.imageOwnerAlias(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("name", targetDepth)) {
                    image.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("rootDeviceName", targetDepth)) {
                    image.rootDeviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("rootDeviceType", targetDepth)) {
                    image.rootDeviceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sriovNetSupport", targetDepth)) {
                    image.sriovNetSupport(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("stateReason", targetDepth)) {
                    image.stateReason(StateReasonUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("virtualizationType", targetDepth)) {
                    image.virtualizationType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("isPublic", targetDepth)) {
                    image.publicLaunchPermissions(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    image.productCodes(productCodes);
                    image.blockDeviceMappings(blockDeviceMappings);
                    image.tags(tags);
                    break;
                }
            }
        }
        return image.build();
    }

    private static final ImageUnmarshaller INSTANCE = new ImageUnmarshaller();

    public static ImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}
