/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ImportInstanceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportInstanceRequestMarshaller implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {

    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {

        if (importInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ImportInstanceRequest> request = new DefaultRequest<ImportInstanceRequest>(importInstanceRequest, "EC2Client");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (importInstanceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(importInstanceRequest.description()));
        }

        java.util.List<DiskImage> importInstanceRequestDiskImagesList = importInstanceRequest.diskImages();
        if (importInstanceRequestDiskImagesList != null) {
            int diskImagesListIndex = 1;

            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {

                if (importInstanceRequestDiskImagesListValue.description() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description",
                            StringUtils.fromString(importInstanceRequestDiskImagesListValue.description()));
                }

                DiskImageDetail image = importInstanceRequestDiskImagesListValue.image();
                if (image != null) {

                    if (image.bytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes",
                                StringUtils.fromLong(image.bytes()));
                    }

                    if (image.formatAsString() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format",
                                StringUtils.fromString(image.formatAsString()));
                    }

                    if (image.importManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl",
                                StringUtils.fromString(image.importManifestUrl()));
                    }
                }

                VolumeDetail volume = importInstanceRequestDiskImagesListValue.volume();
                if (volume != null) {

                    if (volume.size() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size",
                                StringUtils.fromLong(volume.size()));
                    }
                }
                diskImagesListIndex++;
            }
        }

        ImportInstanceLaunchSpecification launchSpecification = importInstanceRequest.launchSpecification();
        if (launchSpecification != null) {

            if (launchSpecification.additionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo",
                        StringUtils.fromString(launchSpecification.additionalInfo()));
            }

            if (launchSpecification.architectureAsString() != null) {
                request.addParameter("LaunchSpecification.Architecture",
                        StringUtils.fromString(launchSpecification.architectureAsString()));
            }

            java.util.List<String> importInstanceLaunchSpecificationGroupIdsList = launchSpecification.groupIds();
            if (importInstanceLaunchSpecificationGroupIdsList != null) {
                int groupIdsListIndex = 1;

                for (String importInstanceLaunchSpecificationGroupIdsListValue : importInstanceLaunchSpecificationGroupIdsList) {
                    if (importInstanceLaunchSpecificationGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex,
                                StringUtils.fromString(importInstanceLaunchSpecificationGroupIdsListValue));
                    }
                    groupIdsListIndex++;
                }
            }

            java.util.List<String> importInstanceLaunchSpecificationGroupNamesList = launchSpecification.groupNames();
            if (importInstanceLaunchSpecificationGroupNamesList != null) {
                int groupNamesListIndex = 1;

                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex,
                                StringUtils.fromString(importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    groupNamesListIndex++;
                }
            }

            if (launchSpecification.instanceInitiatedShutdownBehaviorAsString() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior",
                        StringUtils.fromString(launchSpecification.instanceInitiatedShutdownBehaviorAsString()));
            }

            if (launchSpecification.instanceTypeAsString() != null) {
                request.addParameter("LaunchSpecification.InstanceType",
                        StringUtils.fromString(launchSpecification.instanceTypeAsString()));
            }

            if (launchSpecification.monitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled",
                        StringUtils.fromBoolean(launchSpecification.monitoring()));
            }

            Placement placement = launchSpecification.placement();
            if (placement != null) {

                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone",
                            StringUtils.fromString(placement.availabilityZone()));
                }

                if (placement.affinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString(placement.affinity()));
                }

                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.groupName()));
                }

                if (placement.hostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString(placement.hostId()));
                }

                if (placement.tenancyAsString() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy",
                            StringUtils.fromString(placement.tenancyAsString()));
                }

                if (placement.spreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain",
                            StringUtils.fromString(placement.spreadDomain()));
                }
            }

            if (launchSpecification.privateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress",
                        StringUtils.fromString(launchSpecification.privateIpAddress()));
            }

            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.subnetId()));
            }

            UserData userData = launchSpecification.userData();
            if (userData != null) {

                if (userData.data() != null) {
                    request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString(userData.data()));
                }
            }
        }

        if (importInstanceRequest.platformAsString() != null) {
            request.addParameter("Platform", StringUtils.fromString(importInstanceRequest.platformAsString()));
        }

        return request;
    }

}
