/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyReservedInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyReservedInstancesRequestMarshaller implements
        Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {

    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {

        if (modifyReservedInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyReservedInstancesRequest> request = new DefaultRequest<ModifyReservedInstancesRequest>(
                modifyReservedInstancesRequest, "EC2Client");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> modifyReservedInstancesRequestReservedInstancesIdsList = modifyReservedInstancesRequest
                .reservedInstancesIds();
        if (modifyReservedInstancesRequestReservedInstancesIdsList != null) {
            int reservedInstancesIdsListIndex = 1;

            for (String modifyReservedInstancesRequestReservedInstancesIdsListValue : modifyReservedInstancesRequestReservedInstancesIdsList) {
                if (modifyReservedInstancesRequestReservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex,
                            StringUtils.fromString(modifyReservedInstancesRequestReservedInstancesIdsListValue));
                }
                reservedInstancesIdsListIndex++;
            }
        }

        if (modifyReservedInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(modifyReservedInstancesRequest.clientToken()));
        }

        java.util.List<ReservedInstancesConfiguration> modifyReservedInstancesRequestTargetConfigurationsList = modifyReservedInstancesRequest
                .targetConfigurations();
        if (modifyReservedInstancesRequestTargetConfigurationsList != null) {
            int targetConfigurationsListIndex = 1;

            for (ReservedInstancesConfiguration modifyReservedInstancesRequestTargetConfigurationsListValue : modifyReservedInstancesRequestTargetConfigurationsList) {

                if (modifyReservedInstancesRequestTargetConfigurationsListValue.availabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex
                            + ".AvailabilityZone", StringUtils
                            .fromString(modifyReservedInstancesRequestTargetConfigurationsListValue.availabilityZone()));
                }

                if (modifyReservedInstancesRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex
                            + ".InstanceCount",
                            StringUtils.fromInteger(modifyReservedInstancesRequestTargetConfigurationsListValue.instanceCount()));
                }

                if (modifyReservedInstancesRequestTargetConfigurationsListValue.instanceTypeAsString() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex
                            + ".InstanceType", StringUtils.fromString(modifyReservedInstancesRequestTargetConfigurationsListValue
                            .instanceTypeAsString()));
                }

                if (modifyReservedInstancesRequestTargetConfigurationsListValue.platform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex
                            + ".Platform",
                            StringUtils.fromString(modifyReservedInstancesRequestTargetConfigurationsListValue.platform()));
                }

                if (modifyReservedInstancesRequestTargetConfigurationsListValue.scopeAsString() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Scope",
                            StringUtils.fromString(modifyReservedInstancesRequestTargetConfigurationsListValue.scopeAsString()));
                }
                targetConfigurationsListIndex++;
            }
        }

        return request;
    }

}
