/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * NatGateway StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NatGatewayUnmarshaller implements Unmarshaller<NatGateway, StaxUnmarshallerContext> {

    public NatGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        NatGateway.Builder natGateway = NatGateway.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<NatGatewayAddress> natGatewayAddresses = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                natGateway.natGatewayAddresses(natGatewayAddresses);
                natGateway.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("createTime", targetDepth)) {
                    natGateway.createTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("deleteTime", targetDepth)) {
                    natGateway.deleteTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("failureCode", targetDepth)) {
                    natGateway.failureCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("failureMessage", targetDepth)) {
                    natGateway.failureMessage(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("natGatewayAddressSet", targetDepth)) {
                    natGatewayAddresses = new ArrayList<NatGatewayAddress>();
                    continue;
                }

                if (context.testExpression("natGatewayAddressSet/item", targetDepth)) {
                    natGatewayAddresses.add(NatGatewayAddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("natGatewayId", targetDepth)) {
                    natGateway.natGatewayId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("provisionedBandwidth", targetDepth)) {
                    natGateway.provisionedBandwidth(ProvisionedBandwidthUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    natGateway.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    natGateway.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    natGateway.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    natGateway.natGatewayAddresses(natGatewayAddresses);
                    natGateway.tags(tags);
                    break;
                }
            }
        }
        return natGateway.build();
    }

    private static final NatGatewayUnmarshaller INSTANCE = new NatGatewayUnmarshaller();

    public static NatGatewayUnmarshaller getInstance() {
        return INSTANCE;
    }
}
