/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * NetworkInterfacePermission StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NetworkInterfacePermissionUnmarshaller implements Unmarshaller<NetworkInterfacePermission, StaxUnmarshallerContext> {

    public NetworkInterfacePermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInterfacePermission.Builder networkInterfacePermission = NetworkInterfacePermission.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("networkInterfacePermissionId", targetDepth)) {
                    networkInterfacePermission.networkInterfacePermissionId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    networkInterfacePermission.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("awsAccountId", targetDepth)) {
                    networkInterfacePermission.awsAccountId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("awsService", targetDepth)) {
                    networkInterfacePermission.awsService(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("permission", targetDepth)) {
                    networkInterfacePermission.permission(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("permissionState", targetDepth)) {
                    networkInterfacePermission.permissionState(NetworkInterfacePermissionStateUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return networkInterfacePermission.build();
    }

    private static final NetworkInterfacePermissionUnmarshaller INSTANCE = new NetworkInterfacePermissionUnmarshaller();

    public static NetworkInterfacePermissionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
