/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * NetworkInterface StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NetworkInterfaceUnmarshaller implements Unmarshaller<NetworkInterface, StaxUnmarshallerContext> {

    public NetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInterface.Builder networkInterface = NetworkInterface.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> groups = null;
        java.util.List<NetworkInterfaceIpv6Address> ipv6Addresses = null;
        java.util.List<NetworkInterfacePrivateIpAddress> privateIpAddresses = null;
        java.util.List<Tag> tagSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                networkInterface.groups(groups);
                networkInterface.ipv6Addresses(ipv6Addresses);
                networkInterface.privateIpAddresses(privateIpAddresses);
                networkInterface.tagSet(tagSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("association", targetDepth)) {
                    networkInterface.association(NetworkInterfaceAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("attachment", targetDepth)) {
                    networkInterface.attachment(NetworkInterfaceAttachmentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availabilityZone", targetDepth)) {
                    networkInterface.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    networkInterface.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("interfaceType", targetDepth)) {
                    networkInterface.interfaceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                    ipv6Addresses = new ArrayList<NetworkInterfaceIpv6Address>();
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                    ipv6Addresses.add(NetworkInterfaceIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("macAddress", targetDepth)) {
                    networkInterface.macAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    networkInterface.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    networkInterface.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateDnsName", targetDepth)) {
                    networkInterface.privateDnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddress", targetDepth)) {
                    networkInterface.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                    privateIpAddresses = new ArrayList<NetworkInterfacePrivateIpAddress>();
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                    privateIpAddresses.add(NetworkInterfacePrivateIpAddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("requesterId", targetDepth)) {
                    networkInterface.requesterId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("requesterManaged", targetDepth)) {
                    networkInterface.requesterManaged(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sourceDestCheck", targetDepth)) {
                    networkInterface.sourceDestCheck(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    networkInterface.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    networkInterface.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tagSet = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tagSet.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    networkInterface.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    networkInterface.groups(groups);
                    networkInterface.ipv6Addresses(ipv6Addresses);
                    networkInterface.privateIpAddresses(privateIpAddresses);
                    networkInterface.tagSet(tagSet);
                    break;
                }
            }
        }
        return networkInterface.build();
    }

    private static final NetworkInterfaceUnmarshaller INSTANCE = new NetworkInterfaceUnmarshaller();

    public static NetworkInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
