/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * SecurityGroup StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SecurityGroupUnmarshaller implements Unmarshaller<SecurityGroup, StaxUnmarshallerContext> {

    public SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        SecurityGroup.Builder securityGroup = SecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<IpPermission> ipPermissions = null;
        java.util.List<IpPermission> ipPermissionsEgress = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                securityGroup.ipPermissions(ipPermissions);
                securityGroup.ipPermissionsEgress(ipPermissionsEgress);
                securityGroup.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("groupDescription", targetDepth)) {
                    securityGroup.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupName", targetDepth)) {
                    securityGroup.groupName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipPermissions", targetDepth)) {
                    ipPermissions = new ArrayList<IpPermission>();
                    continue;
                }

                if (context.testExpression("ipPermissions/item", targetDepth)) {
                    ipPermissions.add(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    securityGroup.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupId", targetDepth)) {
                    securityGroup.groupId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipPermissionsEgress", targetDepth)) {
                    ipPermissionsEgress = new ArrayList<IpPermission>();
                    continue;
                }

                if (context.testExpression("ipPermissionsEgress/item", targetDepth)) {
                    ipPermissionsEgress.add(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    securityGroup.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    securityGroup.ipPermissions(ipPermissions);
                    securityGroup.ipPermissionsEgress(ipPermissionsEgress);
                    securityGroup.tags(tags);
                    break;
                }
            }
        }
        return securityGroup.build();
    }

    private static final SecurityGroupUnmarshaller INSTANCE = new SecurityGroupUnmarshaller();

    public static SecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}
