/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * SpotInstanceRequest StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SpotInstanceRequestUnmarshaller implements Unmarshaller<SpotInstanceRequest, StaxUnmarshallerContext> {

    public SpotInstanceRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotInstanceRequest.Builder spotInstanceRequest = SpotInstanceRequest.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                spotInstanceRequest.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("actualBlockHourlyPrice", targetDepth)) {
                    spotInstanceRequest.actualBlockHourlyPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availabilityZoneGroup", targetDepth)) {
                    spotInstanceRequest.availabilityZoneGroup(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDurationMinutes", targetDepth)) {
                    spotInstanceRequest.blockDurationMinutes(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("createTime", targetDepth)) {
                    spotInstanceRequest.createTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("fault", targetDepth)) {
                    spotInstanceRequest.fault(SpotInstanceStateFaultUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceId", targetDepth)) {
                    spotInstanceRequest.instanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchGroup", targetDepth)) {
                    spotInstanceRequest.launchGroup(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchSpecification", targetDepth)) {
                    spotInstanceRequest.launchSpecification(LaunchSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchedAvailabilityZone", targetDepth)) {
                    spotInstanceRequest.launchedAvailabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productDescription", targetDepth)) {
                    spotInstanceRequest.productDescription(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotInstanceRequestId", targetDepth)) {
                    spotInstanceRequest.spotInstanceRequestId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotPrice", targetDepth)) {
                    spotInstanceRequest.spotPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    spotInstanceRequest.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    spotInstanceRequest.status(SpotInstanceStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("type", targetDepth)) {
                    spotInstanceRequest.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("validFrom", targetDepth)) {
                    spotInstanceRequest.validFrom(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("validUntil", targetDepth)) {
                    spotInstanceRequest.validUntil(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceInterruptionBehavior", targetDepth)) {
                    spotInstanceRequest.instanceInterruptionBehavior(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    spotInstanceRequest.tags(tags);
                    break;
                }
            }
        }
        return spotInstanceRequest.build();
    }

    private static final SpotInstanceRequestUnmarshaller INSTANCE = new SpotInstanceRequestUnmarshaller();

    public static SpotInstanceRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}
