/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateHostsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AllocateHostsRequest> {
    private final String autoPlacement;
    private final String availabilityZone;
    private final String clientToken;
    private final String instanceType;
    private final Integer quantity;

    private AllocateHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.quantity = builder.quantity;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer quantity() {
        return this.quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest)((Object)obj);
        return Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.quantity(), other.quantity());
    }

    public String toString() {
        return ToString.builder((String)"AllocateHostsRequest").add("AutoPlacement", (Object)this.autoPlacementAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ClientToken", (Object)this.clientToken()).add("InstanceType", (Object)this.instanceType()).add("Quantity", (Object)this.quantity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.of(clazz.cast(this.autoPlacementAsString()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String autoPlacement;
        private String availabilityZone;
        private String clientToken;
        private String instanceType;
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            super(model);
            this.autoPlacement(model.autoPlacement);
            this.availabilityZone(model.availabilityZone);
            this.clientToken(model.clientToken);
            this.instanceType(model.instanceType);
            this.quantity(model.quantity);
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AllocateHostsRequest> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder availabilityZone(String var1);

        public Builder clientToken(String var1);

        public Builder instanceType(String var1);

        public Builder quantity(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

