/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateSubnetCidrBlockRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
    private final String ipv6CidrBlock;
    private final String subnetId;

    private AssociateSubnetCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.subnetId = builder.subnetId;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String subnetId() {
        return this.subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockRequest)) {
            return false;
        }
        AssociateSubnetCidrBlockRequest other = (AssociateSubnetCidrBlockRequest)((Object)obj);
        return Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateSubnetCidrBlockRequest").add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String ipv6CidrBlock;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockRequest model) {
            super(model);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.subnetId(model.subnetId);
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssociateSubnetCidrBlockRequest build() {
            return new AssociateSubnetCidrBlockRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
        public Builder ipv6CidrBlock(String var1);

        public Builder subnetId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

