/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.AccountAttribute;
import software.amazon.awssdk.services.ec2.model.AccountAttributeListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountAttributesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAttributes = builder.accountAttributes;
    }

    public List<AccountAttribute> accountAttributes() {
        return this.accountAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        return Objects.equals(this.accountAttributes(), other.accountAttributes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountAttributesResponse").add("AccountAttributes", this.accountAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAttributes": {
                return Optional.of(clazz.cast(this.accountAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<AccountAttribute> accountAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            this.accountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute.Builder> getAccountAttributes() {
            return this.accountAttributes != null ? (Collection)this.accountAttributes.stream().map(AccountAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute ... accountAttributes) {
            this.accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(Consumer<AccountAttribute.Builder> ... accountAttributes) {
            this.accountAttributes(Stream.of(accountAttributes).map(c -> (AccountAttribute)((AccountAttribute.Builder)AccountAttribute.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute.BuilderImpl> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copyFromBuilder(accountAttributes);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountAttributes(Collection<AccountAttribute> var1);

        public Builder accountAttributes(AccountAttribute ... var1);

        public Builder accountAttributes(Consumer<AccountAttribute.Builder> ... var1);
    }
}

