/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.FpgaImageIdListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFpgaImagesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeFpgaImagesRequest> {
    private final List<String> fpgaImageIds;
    private final List<String> owners;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeFpgaImagesRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageIds = builder.fpgaImageIds;
        this.owners = builder.owners;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> fpgaImageIds() {
        return this.fpgaImageIds;
    }

    public List<String> owners() {
        return this.owners;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.owners());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesRequest)) {
            return false;
        }
        DescribeFpgaImagesRequest other = (DescribeFpgaImagesRequest)((Object)obj);
        return Objects.equals(this.fpgaImageIds(), other.fpgaImageIds()) && Objects.equals(this.owners(), other.owners()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFpgaImagesRequest").add("FpgaImageIds", this.fpgaImageIds()).add("Owners", this.owners()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageIds": {
                return Optional.of(clazz.cast(this.fpgaImageIds()));
            }
            case "Owners": {
                return Optional.of(clazz.cast(this.owners()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> fpgaImageIds;
        private List<String> owners;
        private List<Filter> filters;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesRequest model) {
            super(model);
            this.fpgaImageIds(model.fpgaImageIds);
            this.owners(model.owners);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getFpgaImageIds() {
            return this.fpgaImageIds;
        }

        @Override
        public final Builder fpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImageIds(String ... fpgaImageIds) {
            this.fpgaImageIds(Arrays.asList(fpgaImageIds));
            return this;
        }

        public final void setFpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
        }

        public final Collection<String> getOwners() {
            return this.owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImagesRequest build() {
            return new DescribeFpgaImagesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeFpgaImagesRequest> {
        public Builder fpgaImageIds(Collection<String> var1);

        public Builder fpgaImageIds(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

