/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIamInstanceProfileAssociationsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;
    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return this.iamInstanceProfileAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse)((Object)obj);
        return Objects.equals(this.iamInstanceProfileAssociations(), other.iamInstanceProfileAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIamInstanceProfileAssociationsResponse").add("IamInstanceProfileAssociations", this.iamInstanceProfileAssociations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamInstanceProfileAssociations": {
                return Optional.of(clazz.cast(this.iamInstanceProfileAssociations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            super(model);
            this.iamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<IamInstanceProfileAssociation.Builder> getIamInstanceProfileAssociations() {
            return this.iamInstanceProfileAssociations != null ? (Collection)this.iamInstanceProfileAssociations.stream().map(IamInstanceProfileAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder> ... iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations(Stream.of(iamInstanceProfileAssociations).map(c -> (IamInstanceProfileAssociation)((IamInstanceProfileAssociation.Builder)IamInstanceProfileAssociation.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation.BuilderImpl> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copyFromBuilder(iamInstanceProfileAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        public Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> var1);

        public Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... var1);

        public Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

