/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.SecurityGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
    private final List<SecurityGroup> securityGroups;
    private final String nextToken;

    private DescribeSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroups = builder.securityGroups;
        this.nextToken = builder.nextToken;
    }

    public List<SecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsResponse)) {
            return false;
        }
        DescribeSecurityGroupsResponse other = (DescribeSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSecurityGroupsResponse").add("SecurityGroups", this.securityGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<SecurityGroup> securityGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsResponse model) {
            super(model);
            this.securityGroups(model.securityGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityGroup.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(SecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroup)((SecurityGroup.Builder)SecurityGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSecurityGroupsResponse build() {
            return new DescribeSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
        public Builder securityGroups(Collection<SecurityGroup> var1);

        public Builder securityGroups(SecurityGroup ... var1);

        public Builder securityGroups(Consumer<SecurityGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

