/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeVolumesRequest> {
    private final List<Filter> filters;
    private final List<String> volumeIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.volumeIds = builder.volumeIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> volumeIds() {
        return this.volumeIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.volumeIds(), other.volumeIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVolumesRequest").add("Filters", this.filters()).add("VolumeIds", this.volumeIds()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "VolumeIds": {
                return Optional.of(clazz.cast(this.volumeIds()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> volumeIds;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            super(model);
            this.filters(model.filters);
            this.volumeIds(model.volumeIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVolumeIds() {
            return this.volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String ... volumeIds) {
            this.volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeVolumesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder volumeIds(Collection<String> var1);

        public Builder volumeIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

