/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableVgwRoutePropagationRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DisableVgwRoutePropagationRequest> {
    private final String gatewayId;
    private final String routeTableId;

    private DisableVgwRoutePropagationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableVgwRoutePropagationRequest)) {
            return false;
        }
        DisableVgwRoutePropagationRequest other = (DisableVgwRoutePropagationRequest)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public String toString() {
        return ToString.builder((String)"DisableVgwRoutePropagationRequest").add("GatewayId", (Object)this.gatewayId()).add("RouteTableId", (Object)this.routeTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.of(clazz.cast(this.gatewayId()));
            }
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableVgwRoutePropagationRequest model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.routeTableId(model.routeTableId);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisableVgwRoutePropagationRequest build() {
            return new DisableVgwRoutePropagationRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DisableVgwRoutePropagationRequest> {
        public Builder gatewayId(String var1);

        public Builder routeTableId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

