/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPasswordDataResponse
extends EC2Response
implements ToCopyableBuilder<Builder, GetPasswordDataResponse> {
    private final String instanceId;
    private final String passwordData;
    private final Instant timestamp;

    private GetPasswordDataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.passwordData = builder.passwordData;
        this.timestamp = builder.timestamp;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String passwordData() {
        return this.passwordData;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordData());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPasswordDataResponse)) {
            return false;
        }
        GetPasswordDataResponse other = (GetPasswordDataResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.passwordData(), other.passwordData()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"GetPasswordDataResponse").add("InstanceId", (Object)this.instanceId()).add("PasswordData", (Object)this.passwordData()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "PasswordData": {
                return Optional.of(clazz.cast(this.passwordData()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String passwordData;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPasswordDataResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.passwordData(model.passwordData);
            this.timestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPasswordData() {
            return this.passwordData;
        }

        @Override
        public final Builder passwordData(String passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public final void setPasswordData(String passwordData) {
            this.passwordData = passwordData;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public GetPasswordDataResponse build() {
            return new GetPasswordDataResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, GetPasswordDataResponse> {
        public Builder instanceId(String var1);

        public Builder passwordData(String var1);

        public Builder timestamp(Instant var1);
    }
}

