/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ListingState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCount
implements ToCopyableBuilder<Builder, InstanceCount> {
    private final Integer instanceCount;
    private final String state;

    private InstanceCount(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ListingState state() {
        return ListingState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCount)) {
            return false;
        }
        InstanceCount other = (InstanceCount)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCount").add("InstanceCount", (Object)this.instanceCount()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCount model) {
            this.instanceCount(model.instanceCount);
            this.state(model.state);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ListingState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public InstanceCount build() {
            return new InstanceCount(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCount> {
        public Builder instanceCount(Integer var1);

        public Builder state(String var1);

        public Builder state(ListingState var1);
    }
}

