/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyIdentityIdFormatRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyIdentityIdFormatRequest> {
    private final String principalArn;
    private final String resource;
    private final Boolean useLongIds;

    private ModifyIdentityIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public String principalArn() {
        return this.principalArn;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLongIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdentityIdFormatRequest)) {
            return false;
        }
        ModifyIdentityIdFormatRequest other = (ModifyIdentityIdFormatRequest)((Object)obj);
        return Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.useLongIds(), other.useLongIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifyIdentityIdFormatRequest").add("PrincipalArn", (Object)this.principalArn()).add("Resource", (Object)this.resource()).add("UseLongIds", (Object)this.useLongIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalArn": {
                return Optional.of(clazz.cast(this.principalArn()));
            }
            case "Resource": {
                return Optional.of(clazz.cast(this.resource()));
            }
            case "UseLongIds": {
                return Optional.of(clazz.cast(this.useLongIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String principalArn;
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdentityIdFormatRequest model) {
            super(model);
            this.principalArn(model.principalArn);
            this.resource(model.resource);
            this.useLongIds(model.useLongIds);
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyIdentityIdFormatRequest build() {
            return new ModifyIdentityIdFormatRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyIdentityIdFormatRequest> {
        public Builder principalArn(String var1);

        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

