/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.Purchase;
import software.amazon.awssdk.services.ec2.model.PurchaseSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseHostReservationResponse
extends EC2Response
implements ToCopyableBuilder<Builder, PurchaseHostReservationResponse> {
    private final String clientToken;
    private final String currencyCode;
    private final List<Purchase> purchase;
    private final String totalHourlyPrice;
    private final String totalUpfrontPrice;

    private PurchaseHostReservationResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public List<Purchase> purchase() {
        return this.purchase;
    }

    public String totalHourlyPrice() {
        return this.totalHourlyPrice;
    }

    public String totalUpfrontPrice() {
        return this.totalUpfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUpfrontPrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationResponse)) {
            return false;
        }
        PurchaseHostReservationResponse other = (PurchaseHostReservationResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.purchase(), other.purchase()) && Objects.equals(this.totalHourlyPrice(), other.totalHourlyPrice()) && Objects.equals(this.totalUpfrontPrice(), other.totalUpfrontPrice());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseHostReservationResponse").add("ClientToken", (Object)this.clientToken()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Purchase", this.purchase()).add("TotalHourlyPrice", (Object)this.totalHourlyPrice()).add("TotalUpfrontPrice", (Object)this.totalUpfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeAsString()));
            }
            case "Purchase": {
                return Optional.of(clazz.cast(this.purchase()));
            }
            case "TotalHourlyPrice": {
                return Optional.of(clazz.cast(this.totalHourlyPrice()));
            }
            case "TotalUpfrontPrice": {
                return Optional.of(clazz.cast(this.totalUpfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private String currencyCode;
        private List<Purchase> purchase;
        private String totalHourlyPrice;
        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.currencyCode(model.currencyCode);
            this.purchase(model.purchase);
            this.totalHourlyPrice(model.totalHourlyPrice);
            this.totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return this.purchase != null ? (Collection)this.purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase ... purchase) {
            this.purchase(Arrays.asList(purchase));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Consumer<Purchase.Builder> ... purchase) {
            this.purchase(Stream.of(purchase).map(c -> (Purchase)((Purchase.Builder)Purchase.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return this.totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return this.totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public PurchaseHostReservationResponse build() {
            return new PurchaseHostReservationResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, PurchaseHostReservationResponse> {
        public Builder clientToken(String var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder purchase(Collection<Purchase> var1);

        public Builder purchase(Purchase ... var1);

        public Builder purchase(Consumer<Purchase.Builder> ... var1);

        public Builder totalHourlyPrice(String var1);

        public Builder totalUpfrontPrice(String var1);
    }
}

