/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseScheduledInstancesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
    private final String clientToken;
    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<PurchaseRequest> purchaseRequests() {
        return this.purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.purchaseRequests(), other.purchaseRequests());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseScheduledInstancesRequest").add("ClientToken", (Object)this.clientToken()).add("PurchaseRequests", this.purchaseRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "PurchaseRequests": {
                return Optional.of(clazz.cast(this.purchaseRequests()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<PurchaseRequest> purchaseRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest.Builder> getPurchaseRequests() {
            return this.purchaseRequests != null ? (Collection)this.purchaseRequests.stream().map(PurchaseRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest ... purchaseRequests) {
            this.purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... purchaseRequests) {
            this.purchaseRequests(Stream.of(purchaseRequests).map(c -> (PurchaseRequest)((PurchaseRequest.Builder)PurchaseRequest.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder purchaseRequests(Collection<PurchaseRequest> var1);

        public Builder purchaseRequests(PurchaseRequest ... var1);

        public Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

