/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BillingProductListCopier;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterImageRequest
extends EC2Request
implements ToCopyableBuilder<Builder, RegisterImageRequest> {
    private final String imageLocation;
    private final String architecture;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final Boolean enaSupport;
    private final String kernelId;
    private final String name;
    private final List<String> billingProducts;
    private final String ramdiskId;
    private final String rootDeviceName;
    private final String sriovNetSupport;
    private final String virtualizationType;

    private RegisterImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageLocation = builder.imageLocation;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.kernelId = builder.kernelId;
        this.name = builder.name;
        this.billingProducts = builder.billingProducts;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.virtualizationType = builder.virtualizationType;
    }

    public String imageLocation() {
        return this.imageLocation;
    }

    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public String architectureAsString() {
        return this.architecture;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String description() {
        return this.description;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String name() {
        return this.name;
    }

    public List<String> billingProducts() {
        return this.billingProducts;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String virtualizationType() {
        return this.virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest)((Object)obj);
        return Objects.equals(this.imageLocation(), other.imageLocation()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.billingProducts(), other.billingProducts()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.virtualizationType(), other.virtualizationType());
    }

    public String toString() {
        return ToString.builder((String)"RegisterImageRequest").add("ImageLocation", (Object)this.imageLocation()).add("Architecture", (Object)this.architectureAsString()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("Description", (Object)this.description()).add("EnaSupport", (Object)this.enaSupport()).add("KernelId", (Object)this.kernelId()).add("Name", (Object)this.name()).add("BillingProducts", this.billingProducts()).add("RamdiskId", (Object)this.ramdiskId()).add("RootDeviceName", (Object)this.rootDeviceName()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("VirtualizationType", (Object)this.virtualizationType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageLocation": {
                return Optional.of(clazz.cast(this.imageLocation()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EnaSupport": {
                return Optional.of(clazz.cast(this.enaSupport()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "BillingProducts": {
                return Optional.of(clazz.cast(this.billingProducts()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "RootDeviceName": {
                return Optional.of(clazz.cast(this.rootDeviceName()));
            }
            case "SriovNetSupport": {
                return Optional.of(clazz.cast(this.sriovNetSupport()));
            }
            case "VirtualizationType": {
                return Optional.of(clazz.cast(this.virtualizationType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String imageLocation;
        private String architecture;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String description;
        private Boolean enaSupport;
        private String kernelId;
        private String name;
        private List<String> billingProducts;
        private String ramdiskId;
        private String rootDeviceName;
        private String sriovNetSupport;
        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterImageRequest model) {
            super(model);
            this.imageLocation(model.imageLocation);
            this.architecture(model.architecture);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.description(model.description);
            this.enaSupport(model.enaSupport);
            this.kernelId(model.kernelId);
            this.name(model.name);
            this.billingProducts(model.billingProducts);
            this.ramdiskId(model.ramdiskId);
            this.rootDeviceName(model.rootDeviceName);
            this.sriovNetSupport(model.sriovNetSupport);
            this.virtualizationType(model.virtualizationType);
        }

        public final String getImageLocation() {
            return this.imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getBillingProducts() {
            return this.billingProducts;
        }

        @Override
        public final Builder billingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingProducts(String ... billingProducts) {
            this.billingProducts(Arrays.asList(billingProducts));
            return this;
        }

        public final void setBillingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterImageRequest build() {
            return new RegisterImageRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, RegisterImageRequest> {
        public Builder imageLocation(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder description(String var1);

        public Builder enaSupport(Boolean var1);

        public Builder kernelId(String var1);

        public Builder name(String var1);

        public Builder billingProducts(Collection<String> var1);

        public Builder billingProducts(String ... var1);

        public Builder ramdiskId(String var1);

        public Builder rootDeviceName(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder virtualizationType(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

