/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceState;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstances
implements ToCopyableBuilder<Builder, ReservedInstances> {
    private final String availabilityZone;
    private final Long duration;
    private final Instant end;
    private final Float fixedPrice;
    private final Integer instanceCount;
    private final String instanceType;
    private final String productDescription;
    private final String reservedInstancesId;
    private final Instant start;
    private final String state;
    private final Float usagePrice;
    private final String currencyCode;
    private final String instanceTenancy;
    private final String offeringClass;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;
    private final List<Tag> tags;

    private ReservedInstances(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.start = builder.start;
        this.state = builder.state;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long duration() {
        return this.duration;
    }

    public Instant end() {
        return this.end;
    }

    public Float fixedPrice() {
        return this.fixedPrice;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionAsString() {
        return this.productDescription;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public Instant start() {
        return this.start;
    }

    public ReservedInstanceState state() {
        return ReservedInstanceState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Float usagePrice() {
        return this.usagePrice;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassAsString() {
        return this.offeringClass;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeAsString() {
        return this.offeringType;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public String scopeAsString() {
        return this.scope;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstances").add("AvailabilityZone", (Object)this.availabilityZone()).add("Duration", (Object)this.duration()).add("End", (Object)this.end()).add("FixedPrice", (Object)this.fixedPrice()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("ReservedInstancesId", (Object)this.reservedInstancesId()).add("Start", (Object)this.start()).add("State", (Object)this.stateAsString()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("OfferingClass", (Object)this.offeringClassAsString()).add("OfferingType", (Object)this.offeringTypeAsString()).add("RecurringCharges", this.recurringCharges()).add("Scope", (Object)this.scopeAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "End": {
                return Optional.of(clazz.cast(this.end()));
            }
            case "FixedPrice": {
                return Optional.of(clazz.cast(this.fixedPrice()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionAsString()));
            }
            case "ReservedInstancesId": {
                return Optional.of(clazz.cast(this.reservedInstancesId()));
            }
            case "Start": {
                return Optional.of(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "UsagePrice": {
                return Optional.of(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeAsString()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyAsString()));
            }
            case "OfferingClass": {
                return Optional.of(clazz.cast(this.offeringClassAsString()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringTypeAsString()));
            }
            case "RecurringCharges": {
                return Optional.of(clazz.cast(this.recurringCharges()));
            }
            case "Scope": {
                return Optional.of(clazz.cast(this.scopeAsString()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long duration;
        private Instant end;
        private Float fixedPrice;
        private Integer instanceCount;
        private String instanceType;
        private String productDescription;
        private String reservedInstancesId;
        private Instant start;
        private String state;
        private Float usagePrice;
        private String currencyCode;
        private String instanceTenancy;
        private String offeringClass;
        private String offeringType;
        private List<RecurringCharge> recurringCharges;
        private String scope;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            this.availabilityZone(model.availabilityZone);
            this.duration(model.duration);
            this.end(model.end);
            this.fixedPrice(model.fixedPrice);
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.productDescription(model.productDescription);
            this.reservedInstancesId(model.reservedInstancesId);
            this.start(model.start);
            this.state(model.state);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.instanceTenancy(model.instanceTenancy);
            this.offeringClass(model.offeringClass);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
            this.scope(model.scope);
            this.tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ReservedInstances build() {
            return new ReservedInstances(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstances> {
        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder end(Instant var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesId(String var1);

        public Builder start(Instant var1);

        public Builder state(String var1);

        public Builder state(ReservedInstanceState var1);

        public Builder usagePrice(Float var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

