/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.PricingDetail;
import software.amazon.awssdk.services.ec2.model.PricingDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesOffering
implements ToCopyableBuilder<Builder, ReservedInstancesOffering> {
    private final String availabilityZone;
    private final Long duration;
    private final Float fixedPrice;
    private final String instanceType;
    private final String productDescription;
    private final String reservedInstancesOfferingId;
    private final Float usagePrice;
    private final String currencyCode;
    private final String instanceTenancy;
    private final Boolean marketplace;
    private final String offeringClass;
    private final String offeringType;
    private final List<PricingDetail> pricingDetails;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long duration() {
        return this.duration;
    }

    public Float fixedPrice() {
        return this.fixedPrice;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionAsString() {
        return this.productDescription;
    }

    public String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public Float usagePrice() {
        return this.usagePrice;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public Boolean marketplace() {
        return this.marketplace;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassAsString() {
        return this.offeringClass;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeAsString() {
        return this.offeringType;
    }

    public List<PricingDetail> pricingDetails() {
        return this.pricingDetails;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public String scopeAsString() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && Objects.equals(this.reservedInstancesOfferingId(), other.reservedInstancesOfferingId()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.marketplace(), other.marketplace()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.pricingDetails(), other.pricingDetails()) && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.scopeAsString(), other.scopeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstancesOffering").add("AvailabilityZone", (Object)this.availabilityZone()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("ReservedInstancesOfferingId", (Object)this.reservedInstancesOfferingId()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("Marketplace", (Object)this.marketplace()).add("OfferingClass", (Object)this.offeringClassAsString()).add("OfferingType", (Object)this.offeringTypeAsString()).add("PricingDetails", this.pricingDetails()).add("RecurringCharges", this.recurringCharges()).add("Scope", (Object)this.scopeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.of(clazz.cast(this.fixedPrice()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionAsString()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "UsagePrice": {
                return Optional.of(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeAsString()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyAsString()));
            }
            case "Marketplace": {
                return Optional.of(clazz.cast(this.marketplace()));
            }
            case "OfferingClass": {
                return Optional.of(clazz.cast(this.offeringClassAsString()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringTypeAsString()));
            }
            case "PricingDetails": {
                return Optional.of(clazz.cast(this.pricingDetails()));
            }
            case "RecurringCharges": {
                return Optional.of(clazz.cast(this.recurringCharges()));
            }
            case "Scope": {
                return Optional.of(clazz.cast(this.scopeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long duration;
        private Float fixedPrice;
        private String instanceType;
        private String productDescription;
        private String reservedInstancesOfferingId;
        private Float usagePrice;
        private String currencyCode;
        private String instanceTenancy;
        private Boolean marketplace;
        private String offeringClass;
        private String offeringType;
        private List<PricingDetail> pricingDetails;
        private List<RecurringCharge> recurringCharges;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            this.availabilityZone(model.availabilityZone);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.instanceType(model.instanceType);
            this.productDescription(model.productDescription);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.instanceTenancy(model.instanceTenancy);
            this.marketplace(model.marketplace);
            this.offeringClass(model.offeringClass);
            this.offeringType(model.offeringType);
            this.pricingDetails(model.pricingDetails);
            this.recurringCharges(model.recurringCharges);
            this.scope(model.scope);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Boolean getMarketplace() {
            return this.marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<PricingDetail.Builder> getPricingDetails() {
            return this.pricingDetails != null ? (Collection)this.pricingDetails.stream().map(PricingDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail ... pricingDetails) {
            this.pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(Consumer<PricingDetail.Builder> ... pricingDetails) {
            this.pricingDetails(Stream.of(pricingDetails).map(c -> (PricingDetail)((PricingDetail.Builder)PricingDetail.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesOffering> {
        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder usagePrice(Float var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder marketplace(Boolean var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder pricingDetails(Collection<PricingDetail> var1);

        public Builder pricingDetails(PricingDetail ... var1);

        public Builder pricingDetails(Consumer<PricingDetail.Builder> ... var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);
    }
}

