/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.DnsEntry;
import software.amazon.awssdk.services.ec2.model.DnsEntrySetCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierSetCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier;
import software.amazon.awssdk.services.ec2.model.State;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcEndpoint
implements ToCopyableBuilder<Builder, VpcEndpoint> {
    private final String vpcEndpointId;
    private final String vpcEndpointType;
    private final String vpcId;
    private final String serviceName;
    private final String state;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final List<String> subnetIds;
    private final List<SecurityGroupIdentifier> groups;
    private final Boolean privateDnsEnabled;
    private final List<String> networkInterfaceIds;
    private final List<DnsEntry> dnsEntries;
    private final Instant creationTimestamp;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.state = builder.state;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.groups = builder.groups;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dnsEntries = builder.dnsEntries;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(this.vpcEndpointType);
    }

    public String vpcEndpointTypeAsString() {
        return this.vpcEndpointType;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public State state() {
        return State.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<SecurityGroupIdentifier> groups() {
        return this.groups;
    }

    public Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public List<DnsEntry> dnsEntries() {
        return this.dnsEntries;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointTypeAsString(), other.vpcEndpointTypeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.routeTableIds(), other.routeTableIds()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.dnsEntries(), other.dnsEntries()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"VpcEndpoint").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointType", (Object)this.vpcEndpointTypeAsString()).add("VpcId", (Object)this.vpcId()).add("ServiceName", (Object)this.serviceName()).add("State", (Object)this.stateAsString()).add("PolicyDocument", (Object)this.policyDocument()).add("RouteTableIds", this.routeTableIds()).add("SubnetIds", this.subnetIds()).add("Groups", this.groups()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("NetworkInterfaceIds", this.networkInterfaceIds()).add("DnsEntries", this.dnsEntries()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.of(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointType": {
                return Optional.of(clazz.cast(this.vpcEndpointTypeAsString()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "RouteTableIds": {
                return Optional.of(clazz.cast(this.routeTableIds()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "PrivateDnsEnabled": {
                return Optional.of(clazz.cast(this.privateDnsEnabled()));
            }
            case "NetworkInterfaceIds": {
                return Optional.of(clazz.cast(this.networkInterfaceIds()));
            }
            case "DnsEntries": {
                return Optional.of(clazz.cast(this.dnsEntries()));
            }
            case "CreationTimestamp": {
                return Optional.of(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String vpcEndpointType;
        private String vpcId;
        private String serviceName;
        private String state;
        private String policyDocument;
        private List<String> routeTableIds;
        private List<String> subnetIds;
        private List<SecurityGroupIdentifier> groups;
        private Boolean privateDnsEnabled;
        private List<String> networkInterfaceIds;
        private List<DnsEntry> dnsEntries;
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointType(model.vpcEndpointType);
            this.vpcId(model.vpcId);
            this.serviceName(model.serviceName);
            this.state(model.state);
            this.policyDocument(model.policyDocument);
            this.routeTableIds(model.routeTableIds);
            this.subnetIds(model.subnetIds);
            this.groups(model.groups);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.dnsEntries(model.dnsEntries);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType.toString());
            return this;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
        }

        public final Collection<SecurityGroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(SecurityGroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<SecurityGroupIdentifier> groups) {
            this.groups = GroupIdentifierSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SecurityGroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<SecurityGroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (SecurityGroupIdentifier)((SecurityGroupIdentifier.Builder)SecurityGroupIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<SecurityGroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierSetCopier.copyFromBuilder(groups);
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return this.networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
        }

        public final Collection<DnsEntry.Builder> getDnsEntries() {
            return this.dnsEntries != null ? (Collection)this.dnsEntries.stream().map(DnsEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsEntries(Collection<DnsEntry> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copy(dnsEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(DnsEntry ... dnsEntries) {
            this.dnsEntries(Arrays.asList(dnsEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(Consumer<DnsEntry.Builder> ... dnsEntries) {
            this.dnsEntries(Stream.of(dnsEntries).map(c -> (DnsEntry)((DnsEntry.Builder)DnsEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDnsEntries(Collection<DnsEntry.BuilderImpl> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copyFromBuilder(dnsEntries);
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcEndpoint> {
        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointType(String var1);

        public Builder vpcEndpointType(VpcEndpointType var1);

        public Builder vpcId(String var1);

        public Builder serviceName(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder groups(Collection<SecurityGroupIdentifier> var1);

        public Builder groups(SecurityGroupIdentifier ... var1);

        public Builder groups(Consumer<SecurityGroupIdentifier.Builder> ... var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder dnsEntries(Collection<DnsEntry> var1);

        public Builder dnsEntries(DnsEntry ... var1);

        public Builder dnsEntries(Consumer<DnsEntry.Builder> ... var1);

        public Builder creationTimestamp(Instant var1);
    }
}

