/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.NatGateway;

public class DescribeNatGatewaysIterable
implements SdkIterable<DescribeNatGatewaysResponse> {
    private final EC2Client client;
    private final DescribeNatGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNatGatewaysIterable(EC2Client client, DescribeNatGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeNatGatewaysResponseFetcher();
    }

    public Iterator<DescribeNatGatewaysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<NatGateway> natGateways() {
        Function<DescribeNatGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.natGateways() != null) {
                return response.natGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeNatGatewaysIterable resume(DescribeNatGatewaysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeNatGatewaysIterable(this.client, (DescribeNatGatewaysRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeNatGatewaysIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeNatGatewaysResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeNatGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeNatGatewaysResponse> {
        private DescribeNatGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNatGatewaysResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeNatGatewaysResponse nextPage(DescribeNatGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeNatGatewaysIterable.this.client.describeNatGateways(DescribeNatGatewaysIterable.this.firstRequest);
            }
            return DescribeNatGatewaysIterable.this.client.describeNatGateways((DescribeNatGatewaysRequest)((Object)DescribeNatGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

