/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.TagDescription;

public class DescribeTagsPublisher
implements SdkPublisher<DescribeTagsResponse> {
    private final EC2AsyncClient client;
    private final DescribeTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTagsPublisher(EC2AsyncClient client, DescribeTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTagsPublisher(EC2AsyncClient client, DescribeTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<TagDescription> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeTagsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeTagsPublisher resume(DescribeTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTagsPublisher(this.client, (DescribeTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeTagsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeTagsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeTagsResponseFetcher
    implements AsyncPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeTagsResponse> nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsPublisher.this.client.describeTags(DescribeTagsPublisher.this.firstRequest);
            }
            return DescribeTagsPublisher.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

