/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;

public class DescribeVolumeStatusIterable
implements SdkIterable<DescribeVolumeStatusResponse> {
    private final EC2Client client;
    private final DescribeVolumeStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVolumeStatusIterable(EC2Client client, DescribeVolumeStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumeStatusResponseFetcher();
    }

    public Iterator<DescribeVolumeStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<VolumeStatusItem> volumeStatuses() {
        Function<DescribeVolumeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeStatuses() != null) {
                return response.volumeStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeVolumeStatusIterable resume(DescribeVolumeStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVolumeStatusIterable(this.client, (DescribeVolumeStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeVolumeStatusIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeVolumeStatusResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeVolumeStatusResponseFetcher
    implements SyncPageFetcher<DescribeVolumeStatusResponse> {
        private DescribeVolumeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumeStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeVolumeStatusResponse nextPage(DescribeVolumeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumeStatusIterable.this.client.describeVolumeStatus(DescribeVolumeStatusIterable.this.firstRequest);
            }
            return DescribeVolumeStatusIterable.this.client.describeVolumeStatus((DescribeVolumeStatusRequest)((Object)DescribeVolumeStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

