/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;

public class CreateNetworkInterfacePermissionRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfacePermissionRequest>, CreateNetworkInterfacePermissionRequest> {
    public Request<CreateNetworkInterfacePermissionRequest> marshall(CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {
        if (createNetworkInterfacePermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createNetworkInterfacePermissionRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkInterfacePermission");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfacePermissionRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)createNetworkInterfacePermissionRequest.networkInterfaceId()));
        }
        if (createNetworkInterfacePermissionRequest.awsAccountId() != null) {
            request.addParameter("AwsAccountId", StringUtils.fromString((String)createNetworkInterfacePermissionRequest.awsAccountId()));
        }
        if (createNetworkInterfacePermissionRequest.awsService() != null) {
            request.addParameter("AwsService", StringUtils.fromString((String)createNetworkInterfacePermissionRequest.awsService()));
        }
        if (createNetworkInterfacePermissionRequest.permissionAsString() != null) {
            request.addParameter("Permission", StringUtils.fromString((String)createNetworkInterfacePermissionRequest.permissionAsString()));
        }
        return request;
    }
}

