/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;

public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        List<PriceScheduleSpecification> createReservedInstancesListingRequestPriceSchedulesList;
        if (createReservedInstancesListingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createReservedInstancesListingRequest, "EC2Client");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReservedInstancesListingRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createReservedInstancesListingRequest.clientToken()));
        }
        if (createReservedInstancesListingRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createReservedInstancesListingRequest.instanceCount()));
        }
        if ((createReservedInstancesListingRequestPriceSchedulesList = createReservedInstancesListingRequest.priceSchedules()) != null) {
            int priceSchedulesListIndex = 1;
            for (PriceScheduleSpecification createReservedInstancesListingRequestPriceSchedulesListValue : createReservedInstancesListingRequestPriceSchedulesList) {
                if (createReservedInstancesListingRequestPriceSchedulesListValue.currencyCodeAsString() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString((String)createReservedInstancesListingRequestPriceSchedulesListValue.currencyCodeAsString()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.price() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble((Double)createReservedInstancesListingRequestPriceSchedulesListValue.price()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.term() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong((Long)createReservedInstancesListingRequestPriceSchedulesListValue.term()));
                }
                ++priceSchedulesListIndex;
            }
        }
        if (createReservedInstancesListingRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)createReservedInstancesListingRequest.reservedInstancesId()));
        }
        return request;
    }
}

