/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeMovingAddressesRequestMarshaller
implements Marshaller<Request<DescribeMovingAddressesRequest>, DescribeMovingAddressesRequest> {
    public Request<DescribeMovingAddressesRequest> marshall(DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        List<String> describeMovingAddressesRequestPublicIpsList;
        if (describeMovingAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeMovingAddressesRequest, "EC2Client");
        request.addParameter("Action", "DescribeMovingAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeMovingAddressesRequestFiltersList = describeMovingAddressesRequest.filters();
        if (describeMovingAddressesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeMovingAddressesRequestFiltersListValue : describeMovingAddressesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeMovingAddressesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeMovingAddressesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeMovingAddressesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeMovingAddressesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeMovingAddressesRequest.maxResults()));
        }
        if (describeMovingAddressesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeMovingAddressesRequest.nextToken()));
        }
        if ((describeMovingAddressesRequestPublicIpsList = describeMovingAddressesRequest.publicIps()) != null) {
            int publicIpsListIndex = 1;
            for (String describeMovingAddressesRequestPublicIpsListValue : describeMovingAddressesRequestPublicIpsList) {
                if (describeMovingAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeMovingAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        return request;
    }
}

