/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DnsEntry;

public class DnsEntryUnmarshaller
implements Unmarshaller<DnsEntry, StaxUnmarshallerContext> {
    private static final DnsEntryUnmarshaller INSTANCE = new DnsEntryUnmarshaller();

    public DnsEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DnsEntry.Builder dnsEntry = DnsEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("dnsName", targetDepth)) {
                    dnsEntry.dnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("hostedZoneId", targetDepth)) continue;
                dnsEntry.hostedZoneId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DnsEntry)dnsEntry.build();
    }

    public static DnsEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

