/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.EventInformation;

public class EventInformationUnmarshaller
implements Unmarshaller<EventInformation, StaxUnmarshallerContext> {
    private static final EventInformationUnmarshaller INSTANCE = new EventInformationUnmarshaller();

    public EventInformation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EventInformation.Builder eventInformation = EventInformation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("eventDescription", targetDepth)) {
                    eventInformation.eventDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventSubType", targetDepth)) {
                    eventInformation.eventSubType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceId", targetDepth)) continue;
                eventInformation.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EventInformation)eventInformation.build();
    }

    public static EventInformationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

