/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ExportToS3Task;

public class ExportToS3TaskUnmarshaller
implements Unmarshaller<ExportToS3Task, StaxUnmarshallerContext> {
    private static final ExportToS3TaskUnmarshaller INSTANCE = new ExportToS3TaskUnmarshaller();

    public ExportToS3Task unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ExportToS3Task.Builder exportToS3Task = ExportToS3Task.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("containerFormat", targetDepth)) {
                    exportToS3Task.containerFormat(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("diskImageFormat", targetDepth)) {
                    exportToS3Task.diskImageFormat(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("s3Bucket", targetDepth)) {
                    exportToS3Task.s3Bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("s3Key", targetDepth)) continue;
                exportToS3Task.s3Key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ExportToS3Task)exportToS3Task.build();
    }

    public static ExportToS3TaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

