/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.IdFormat;

public class IdFormatUnmarshaller
implements Unmarshaller<IdFormat, StaxUnmarshallerContext> {
    private static final IdFormatUnmarshaller INSTANCE = new IdFormatUnmarshaller();

    public IdFormat unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IdFormat.Builder idFormat = IdFormat.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("deadline", targetDepth)) {
                    idFormat.deadline(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("resource", targetDepth)) {
                    idFormat.resource(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("useLongIds", targetDepth)) continue;
                idFormat.useLongIds(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IdFormat)idFormat.build();
    }

    public static IdFormatUnmarshaller getInstance() {
        return INSTANCE;
    }
}

