/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;

public class ModifyInstancePlacementRequestMarshaller
implements Marshaller<Request<ModifyInstancePlacementRequest>, ModifyInstancePlacementRequest> {
    public Request<ModifyInstancePlacementRequest> marshall(ModifyInstancePlacementRequest modifyInstancePlacementRequest) {
        if (modifyInstancePlacementRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyInstancePlacementRequest, "EC2Client");
        request.addParameter("Action", "ModifyInstancePlacement");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstancePlacementRequest.affinityAsString() != null) {
            request.addParameter("Affinity", StringUtils.fromString((String)modifyInstancePlacementRequest.affinityAsString()));
        }
        if (modifyInstancePlacementRequest.hostId() != null) {
            request.addParameter("HostId", StringUtils.fromString((String)modifyInstancePlacementRequest.hostId()));
        }
        if (modifyInstancePlacementRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)modifyInstancePlacementRequest.instanceId()));
        }
        if (modifyInstancePlacementRequest.tenancyAsString() != null) {
            request.addParameter("Tenancy", StringUtils.fromString((String)modifyInstancePlacementRequest.tenancyAsString()));
        }
        return request;
    }
}

