/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;

public class ModifyVpcTenancyRequestMarshaller
implements Marshaller<Request<ModifyVpcTenancyRequest>, ModifyVpcTenancyRequest> {
    public Request<ModifyVpcTenancyRequest> marshall(ModifyVpcTenancyRequest modifyVpcTenancyRequest) {
        if (modifyVpcTenancyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcTenancyRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcTenancy");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcTenancyRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)modifyVpcTenancyRequest.vpcId()));
        }
        if (modifyVpcTenancyRequest.instanceTenancyAsString() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)modifyVpcTenancyRequest.instanceTenancyAsString()));
        }
        return request;
    }
}

