/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;

public class MonitorInstancesRequestMarshaller
implements Marshaller<Request<MonitorInstancesRequest>, MonitorInstancesRequest> {
    public Request<MonitorInstancesRequest> marshall(MonitorInstancesRequest monitorInstancesRequest) {
        if (monitorInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)monitorInstancesRequest, "EC2Client");
        request.addParameter("Action", "MonitorInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> monitorInstancesRequestInstanceIdsList = monitorInstancesRequest.instanceIds();
        if (monitorInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String monitorInstancesRequestInstanceIdsListValue : monitorInstancesRequestInstanceIdsList) {
                if (monitorInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)monitorInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

