/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntry;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.NetworkAclAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkAclEntryUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class NetworkAclUnmarshaller
implements Unmarshaller<NetworkAcl, StaxUnmarshallerContext> {
    private static final NetworkAclUnmarshaller INSTANCE = new NetworkAclUnmarshaller();

    public NetworkAcl unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkAcl.Builder networkAcl;
        block12: {
            networkAcl = NetworkAcl.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<NetworkAclAssociation> associations = null;
            ArrayList<NetworkAclEntry> entries = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    networkAcl.associations(associations);
                    networkAcl.entries(entries);
                    networkAcl.tags(tags);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("associationSet", targetDepth)) {
                        associations = new ArrayList<NetworkAclAssociation>();
                        continue;
                    }
                    if (context.testExpression("associationSet/item", targetDepth)) {
                        associations.add(NetworkAclAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("entrySet", targetDepth)) {
                        entries = new ArrayList<NetworkAclEntry>();
                        continue;
                    }
                    if (context.testExpression("entrySet/item", targetDepth)) {
                        entries.add(NetworkAclEntryUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("default", targetDepth)) {
                        networkAcl.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkAclId", targetDepth)) {
                        networkAcl.networkAclId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    networkAcl.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            networkAcl.associations(associations);
            networkAcl.entries(entries);
            networkAcl.tags(tags);
        }
        return (NetworkAcl)networkAcl.build();
    }

    public static NetworkAclUnmarshaller getInstance() {
        return INSTANCE;
    }
}

