/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkInterfaceAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkInterfaceAttachmentUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkInterfaceIpv6AddressUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkInterfacePrivateIpAddressUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class NetworkInterfaceUnmarshaller
implements Unmarshaller<NetworkInterface, StaxUnmarshallerContext> {
    private static final NetworkInterfaceUnmarshaller INSTANCE = new NetworkInterfaceUnmarshaller();

    public NetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInterface.Builder networkInterface;
        block27: {
            networkInterface = NetworkInterface.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> groups = null;
            ArrayList<NetworkInterfaceIpv6Address> ipv6Addresses = null;
            ArrayList<NetworkInterfacePrivateIpAddress> privateIpAddresses = null;
            ArrayList<Tag> tagSet = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    networkInterface.groups(groups);
                    networkInterface.ipv6Addresses(ipv6Addresses);
                    networkInterface.privateIpAddresses(privateIpAddresses);
                    networkInterface.tagSet(tagSet);
                    break block27;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("association", targetDepth)) {
                        networkInterface.association(NetworkInterfaceAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("attachment", targetDepth)) {
                        networkInterface.attachment(NetworkInterfaceAttachmentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availabilityZone", targetDepth)) {
                        networkInterface.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("description", targetDepth)) {
                        networkInterface.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("interfaceType", targetDepth)) {
                        networkInterface.interfaceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                        ipv6Addresses = new ArrayList<NetworkInterfaceIpv6Address>();
                        continue;
                    }
                    if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                        ipv6Addresses.add(NetworkInterfaceIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("macAddress", targetDepth)) {
                        networkInterface.macAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceId", targetDepth)) {
                        networkInterface.networkInterfaceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ownerId", targetDepth)) {
                        networkInterface.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateDnsName", targetDepth)) {
                        networkInterface.privateDnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateIpAddress", targetDepth)) {
                        networkInterface.privateIpAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                        privateIpAddresses = new ArrayList<NetworkInterfacePrivateIpAddress>();
                        continue;
                    }
                    if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                        privateIpAddresses.add(NetworkInterfacePrivateIpAddressUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("requesterId", targetDepth)) {
                        networkInterface.requesterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("requesterManaged", targetDepth)) {
                        networkInterface.requesterManaged(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("sourceDestCheck", targetDepth)) {
                        networkInterface.sourceDestCheck(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("status", targetDepth)) {
                        networkInterface.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        networkInterface.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tagSet = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tagSet.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    networkInterface.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            networkInterface.groups(groups);
            networkInterface.ipv6Addresses(ipv6Addresses);
            networkInterface.privateIpAddresses(privateIpAddresses);
            networkInterface.tagSet(tagSet);
        }
        return (NetworkInterface)networkInterface.build();
    }

    public static NetworkInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

