/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PciId;

public class PciIdUnmarshaller
implements Unmarshaller<PciId, StaxUnmarshallerContext> {
    private static final PciIdUnmarshaller INSTANCE = new PciIdUnmarshaller();

    public PciId unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PciId.Builder pciId = PciId.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DeviceId", targetDepth)) {
                    pciId.deviceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VendorId", targetDepth)) {
                    pciId.vendorId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubsystemId", targetDepth)) {
                    pciId.subsystemId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SubsystemVendorId", targetDepth)) continue;
                pciId.subsystemVendorId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PciId)pciId.build();
    }

    public static PciIdUnmarshaller getInstance() {
        return INSTANCE;
    }
}

