/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneState")
                    .unmarshallLocationName("zoneState").build()).build();

    private static final SdkField<List<AvailabilityZoneMessage>> MESSAGES_FIELD = SdkField
            .<List<AvailabilityZoneMessage>> builder(MarshallingType.LIST)
            .getter(getter(AvailabilityZone::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSet")
                    .unmarshallLocationName("messageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName")
                    .unmarshallLocationName("regionName").build()).build();

    private static final SdkField<String> ZONE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::zoneName))
            .setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName")
                    .unmarshallLocationName("zoneName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, MESSAGES_FIELD,
            REGION_NAME_FIELD, ZONE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final List<AvailabilityZoneMessage> messages;

    private final String regionName;

    private final String zoneName;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailabilityZoneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Availability Zone.
     * @see AvailabilityZoneState
     */
    public AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailabilityZoneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Availability Zone.
     * @see AvailabilityZoneState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Any messages about the Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any messages about the Availability Zone.
     */
    public List<AvailabilityZoneMessage> messages() {
        return messages;
    }

    /**
     * <p>
     * The name of the region.
     * </p>
     * 
     * @return The name of the region.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The name of the Availability Zone.
     * </p>
     * 
     * @return The name of the Availability Zone.
     */
    public String zoneName() {
        return zoneName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(messages(), other.messages())
                && Objects.equals(regionName(), other.regionName()) && Objects.equals(zoneName(), other.zoneName());
    }

    @Override
    public String toString() {
        return ToString.builder("AvailabilityZone").add("State", stateAsString()).add("Messages", messages())
                .add("RegionName", regionName()).add("ZoneName", zoneName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ZoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(AvailabilityZoneState state);

        /**
         * <p>
         * Any messages about the Availability Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<AvailabilityZoneMessage> messages);

        /**
         * <p>
         * Any messages about the Availability Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(AvailabilityZoneMessage... messages);

        /**
         * <p>
         * Any messages about the Availability Zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailabilityZoneMessage>.Builder} avoiding
         * the need to create one manually via {@link List<AvailabilityZoneMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZoneMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link #messages(List<AvailabilityZoneMessage>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link List<AvailabilityZoneMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(List<AvailabilityZoneMessage>)
         */
        Builder messages(Consumer<AvailabilityZoneMessage.Builder>... messages);

        /**
         * <p>
         * The name of the region.
         * </p>
         * 
         * @param regionName
         *        The name of the region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The name of the Availability Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private List<AvailabilityZoneMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private String regionName;

        private String zoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            state(model.state);
            messages(model.messages);
            regionName(model.regionName);
            zoneName(model.zoneName);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<AvailabilityZoneMessage.Builder> getMessages() {
            return messages != null ? messages.stream().map(AvailabilityZoneMessage::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AvailabilityZoneMessage.Builder>... messages) {
            messages(Stream.of(messages).map(c -> AvailabilityZoneMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
