/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNetworkAcl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkAclResponse extends Ec2Response implements
        ToCopyableBuilder<CreateNetworkAclResponse.Builder, CreateNetworkAclResponse> {
    private static final SdkField<NetworkAcl> NETWORK_ACL_FIELD = SdkField
            .<NetworkAcl> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateNetworkAclResponse::networkAcl))
            .setter(setter(Builder::networkAcl))
            .constructor(NetworkAcl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAcl")
                    .unmarshallLocationName("networkAcl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACL_FIELD));

    private final NetworkAcl networkAcl;

    private CreateNetworkAclResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcl = builder.networkAcl;
    }

    /**
     * <p>
     * Information about the network ACL.
     * </p>
     * 
     * @return Information about the network ACL.
     */
    public NetworkAcl networkAcl() {
        return networkAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAcl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclResponse)) {
            return false;
        }
        CreateNetworkAclResponse other = (CreateNetworkAclResponse) obj;
        return Objects.equals(networkAcl(), other.networkAcl());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateNetworkAclResponse").add("NetworkAcl", networkAcl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAcl":
            return Optional.ofNullable(clazz.cast(networkAcl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAclResponse, T> g) {
        return obj -> g.apply((CreateNetworkAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkAclResponse> {
        /**
         * <p>
         * Information about the network ACL.
         * </p>
         * 
         * @param networkAcl
         *        Information about the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcl(NetworkAcl networkAcl);

        /**
         * <p>
         * Information about the network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkAcl.Builder} avoiding the need to create
         * one manually via {@link NetworkAcl#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkAcl.Builder#build()} is called immediately and its result
         * is passed to {@link #networkAcl(NetworkAcl)}.
         * 
         * @param networkAcl
         *        a consumer that will call methods on {@link NetworkAcl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAcl(NetworkAcl)
         */
        default Builder networkAcl(Consumer<NetworkAcl.Builder> networkAcl) {
            return networkAcl(NetworkAcl.builder().applyMutation(networkAcl).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private NetworkAcl networkAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclResponse model) {
            super(model);
            networkAcl(model.networkAcl);
        }

        public final NetworkAcl.Builder getNetworkAcl() {
            return networkAcl != null ? networkAcl.toBuilder() : null;
        }

        @Override
        public final Builder networkAcl(NetworkAcl networkAcl) {
            this.networkAcl = networkAcl;
            return this;
        }

        public final void setNetworkAcl(NetworkAcl.BuilderImpl networkAcl) {
            this.networkAcl = networkAcl != null ? networkAcl.build() : null;
        }

        @Override
        public CreateNetworkAclResponse build() {
            return new CreateNetworkAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
