/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddressesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeAddressesResponse.Builder, DescribeAddressesResponse> {
    private static final SdkField<List<Address>> ADDRESSES_FIELD = SdkField
            .<List<Address>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAddressesResponse::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressesSet")
                    .unmarshallLocationName("addressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD));

    private final List<Address> addresses;

    private DescribeAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
    }

    /**
     * <p>
     * Information about one or more Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more Elastic IP addresses.
     */
    public List<Address> addresses() {
        return addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse) obj;
        return Objects.equals(addresses(), other.addresses());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAddressesResponse").add("Addresses", addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesResponse, T> g) {
        return obj -> g.apply((DescribeAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddressesResponse> {
        /**
         * <p>
         * Information about one or more Elastic IP addresses.
         * </p>
         * 
         * @param addresses
         *        Information about one or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<Address> addresses);

        /**
         * <p>
         * Information about one or more Elastic IP addresses.
         * </p>
         * 
         * @param addresses
         *        Information about one or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Address... addresses);

        /**
         * <p>
         * Information about one or more Elastic IP addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Address>.Builder} avoiding the need to
         * create one manually via {@link List<Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Address>.Builder#build()} is called immediately and its
         * result is passed to {@link #addresses(List<Address>)}.
         * 
         * @param addresses
         *        a consumer that will call methods on {@link List<Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addresses(List<Address>)
         */
        Builder addresses(Consumer<Address.Builder>... addresses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Address> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            super(model);
            addresses(model.addresses);
        }

        public final Collection<Address.Builder> getAddresses() {
            return addresses != null ? addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<Address.Builder>... addresses) {
            addresses(Stream.of(addresses).map(c -> Address.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        @Override
        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
