/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeMovingAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMovingAddressesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeMovingAddressesResponse.Builder, DescribeMovingAddressesResponse> {
    private static final SdkField<List<MovingAddressStatus>> MOVING_ADDRESS_STATUSES_FIELD = SdkField
            .<List<MovingAddressStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMovingAddressesResponse::movingAddressStatuses))
            .setter(setter(Builder::movingAddressStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MovingAddressStatusSet")
                    .unmarshallLocationName("movingAddressStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<MovingAddressStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(MovingAddressStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMovingAddressesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOVING_ADDRESS_STATUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MovingAddressStatus> movingAddressStatuses;

    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The status for each Elastic IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The status for each Elastic IP address.
     */
    public List<MovingAddressStatus> movingAddressStatuses() {
        return movingAddressStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(movingAddressStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse) obj;
        return Objects.equals(movingAddressStatuses(), other.movingAddressStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMovingAddressesResponse").add("MovingAddressStatuses", movingAddressStatuses())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MovingAddressStatuses":
            return Optional.ofNullable(clazz.cast(movingAddressStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMovingAddressesResponse, T> g) {
        return obj -> g.apply((DescribeMovingAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses);

        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses);

        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MovingAddressStatus>.Builder} avoiding the
         * need to create one manually via {@link List<MovingAddressStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MovingAddressStatus>.Builder#build()} is called immediately
         * and its result is passed to {@link #movingAddressStatuses(List<MovingAddressStatus>)}.
         * 
         * @param movingAddressStatuses
         *        a consumer that will call methods on {@link List<MovingAddressStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #movingAddressStatuses(List<MovingAddressStatus>)
         */
        Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder>... movingAddressStatuses);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            super(model);
            movingAddressStatuses(model.movingAddressStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus.Builder> getMovingAddressStatuses() {
            return movingAddressStatuses != null ? movingAddressStatuses.stream().map(MovingAddressStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses) {
            movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder>... movingAddressStatuses) {
            movingAddressStatuses(Stream.of(movingAddressStatuses)
                    .map(c -> MovingAddressStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus.BuilderImpl> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copyFromBuilder(movingAddressStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
