/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribePlacementGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePlacementGroupsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribePlacementGroupsRequest.Builder, DescribePlacementGroupsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribePlacementGroupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribePlacementGroupsRequest::groupNames))
            .setter(setter(Builder::groupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            GROUP_NAMES_FIELD));

    private final List<Filter> filters;

    private final List<String> groupNames;

    private DescribePlacementGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.groupNames = builder.groupNames;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the placement group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the placement group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more placement group names.
     * </p>
     * <p>
     * Default: Describes all your placement groups, or only those otherwise specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more placement group names.</p>
     *         <p>
     *         Default: Describes all your placement groups, or only those otherwise specified.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsRequest)) {
            return false;
        }
        DescribePlacementGroupsRequest other = (DescribePlacementGroupsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(groupNames(), other.groupNames());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePlacementGroupsRequest").add("Filters", filters()).add("GroupNames", groupNames())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupNames":
            return Optional.ofNullable(clazz.cast(groupNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlacementGroupsRequest, T> g) {
        return obj -> g.apply((DescribePlacementGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribePlacementGroupsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the placement group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the placement group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>strategy</code> - The strategy of the placement group (<code>cluster</code> |
         *        <code>spread</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the placement group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the placement group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>strategy</code> - The strategy of the placement group (<code>cluster</code> |
         *        <code>spread</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the placement group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more placement group names.
         * </p>
         * <p>
         * Default: Describes all your placement groups, or only those otherwise specified.
         * </p>
         * 
         * @param groupNames
         *        One or more placement group names.</p>
         *        <p>
         *        Default: Describes all your placement groups, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more placement group names.
         * </p>
         * <p>
         * Default: Describes all your placement groups, or only those otherwise specified.
         * </p>
         * 
         * @param groupNames
         *        One or more placement group names.</p>
         *        <p>
         *        Default: Describes all your placement groups, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsRequest model) {
            super(model);
            filters(model.filters);
            groupNames(model.groupNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePlacementGroupsRequest build() {
            return new DescribePlacementGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
